# count lines and sections in joke
BEGIN {
 i=0 ; j=0 ; k=0; starter=0;
 out=strftime("j%y%m%d.sta",systime())
}
# version number and header
/^Version/ && (!starter){
  version=$0 ; starter=1;
  printf("Science Jokes Collection %s\n", $0) > out;
  printf("%-36s %6s %5s %10s\n",\
         "SECTION","JOKES","LINES","LINES/JOKE") > out;
  for(s=0;s<=75;s++) {printf("_") > out;}; printf("\n") >out;
  printf("%-36s","") > out;
}

# last time posted
/^* New entry since last time posted/ {
  start=index($0,"(")
  end=length($0)
  last_posted= substr($0,start,end-start+1) }

# next joke
/______________________/&&/M/ {imath++}
/______________________/&&/P/ {iphys++}
/______________________/&&/C/ {ichem++}
/______________________/&&/E/ {ieng++}
/______________________/&&/B/ {ibio++}
/______________________/&&/A/ {icomp++}
/______________________/&&/^[*]/ {inew++}
/______________________/&&/&/ {ichange++}
/______________________/ {i++ ;i0++}
# new section is characterized by number at beginning and all capital text.
  /^=[0-9]+\. / && !/[a-z]/ {
 totk=NR-tot;
 a=i?(totk/i):0 ;
 printf(" %6d %5d %10.4f\n",i,totk,a) > out;
 if (length($0)>36)  {printf("%s\n%36s",$0,"")>out}\
  else {printf("%-36s",$0)> out} ;
 tot=NR; k++; i=0; j=0;
}

END { 
 totk=NR-tot;
 printf(" %6d %5d %10.4f\n",i,totk,totk/i) > out;
 for(s=0;s<=75;s++) {printf("_")>out;}; printf("\n")>out;
 printf("%-36s %6d %5d %10.4f\n","TOTAL",i0,NR,NR/i0,j0) > out;

 printf("\n%16s %10s\n","Jokes including:","Number:")>out
 printf("%16s %10d\n","mathematics",imath)>out
 printf("%16s %10d\n","physics",iphys)>out
 printf("%16s %10d\n","chemistry",ichem)>out
 printf("%16s %10d\n","biology",ibio)>out
 printf("%16s %10d\n","engineering",ieng)>out
 printf("%16s %10d\n","computer science",icomp)>out
 printf("\nNew jokes since last posting %s : %10d\n",last_posted,inew)>out
 printf("Changed jokes since last posting %s : %6d\n",last_posted,ichange)>out
}
